package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  ProductDescription,
  ReviewValue,
  ReviewKey,
  GenericKeyword,
  EndUserLicenseAgreement,
  SkillStoreType,
  BulletPoint,
  ReleaseDate,
  InvocationPhrase
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SkillDetails(
    productDescription: Optional[ProductDescription] = Optional.Absent,
    invocationPhrase: Optional[InvocationPhrase] = Optional.Absent,
    releaseDate: Optional[ReleaseDate] = Optional.Absent,
    endUserLicenseAgreement: Optional[EndUserLicenseAgreement] =
      Optional.Absent,
    genericKeywords: Optional[Iterable[GenericKeyword]] = Optional.Absent,
    bulletPoints: Optional[Iterable[BulletPoint]] = Optional.Absent,
    newInThisVersionBulletPoints: Optional[Iterable[BulletPoint]] =
      Optional.Absent,
    skillTypes: Optional[Iterable[SkillStoreType]] = Optional.Absent,
    reviews: Optional[Map[ReviewKey, ReviewValue]] = Optional.Absent,
    developerInfo: Optional[zio.aws.alexaforbusiness.model.DeveloperInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SkillDetails = {
    import SkillDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SkillDetails
      .builder()
      .optionallyWith(
        productDescription.map(value =>
          ProductDescription.unwrap(value): java.lang.String
        )
      )(_.productDescription)
      .optionallyWith(
        invocationPhrase.map(value =>
          InvocationPhrase.unwrap(value): java.lang.String
        )
      )(_.invocationPhrase)
      .optionallyWith(
        releaseDate.map(value => ReleaseDate.unwrap(value): java.lang.String)
      )(_.releaseDate)
      .optionallyWith(
        endUserLicenseAgreement.map(value =>
          EndUserLicenseAgreement.unwrap(value): java.lang.String
        )
      )(_.endUserLicenseAgreement)
      .optionallyWith(
        genericKeywords.map(value =>
          value.map { item =>
            GenericKeyword.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.genericKeywords)
      .optionallyWith(
        bulletPoints.map(value =>
          value.map { item =>
            BulletPoint.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.bulletPoints)
      .optionallyWith(
        newInThisVersionBulletPoints.map(value =>
          value.map { item =>
            BulletPoint.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.newInThisVersionBulletPoints)
      .optionallyWith(
        skillTypes.map(value =>
          value.map { item =>
            SkillStoreType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.skillTypes)
      .optionallyWith(
        reviews.map(value =>
          value
            .map({ case (key, value) =>
              (ReviewKey.unwrap(key): java.lang.String) -> (ReviewValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.reviews)
      .optionallyWith(developerInfo.map(value => value.buildAwsValue()))(
        _.developerInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.SkillDetails.ReadOnly =
    zio.aws.alexaforbusiness.model.SkillDetails.wrap(buildAwsValue())
}
object SkillDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SkillDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SkillDetails =
      zio.aws.alexaforbusiness.model.SkillDetails(
        productDescription.map(value => value),
        invocationPhrase.map(value => value),
        releaseDate.map(value => value),
        endUserLicenseAgreement.map(value => value),
        genericKeywords.map(value => value),
        bulletPoints.map(value => value),
        newInThisVersionBulletPoints.map(value => value),
        skillTypes.map(value => value),
        reviews.map(value => value),
        developerInfo.map(value => value.asEditable)
      )
    def productDescription: Optional[ProductDescription]
    def invocationPhrase: Optional[InvocationPhrase]
    def releaseDate: Optional[ReleaseDate]
    def endUserLicenseAgreement: Optional[EndUserLicenseAgreement]
    def genericKeywords: Optional[List[GenericKeyword]]
    def bulletPoints: Optional[List[BulletPoint]]
    def newInThisVersionBulletPoints: Optional[List[BulletPoint]]
    def skillTypes: Optional[List[SkillStoreType]]
    def reviews: Optional[Map[ReviewKey, ReviewValue]]
    def developerInfo
        : Optional[zio.aws.alexaforbusiness.model.DeveloperInfo.ReadOnly]
    def getProductDescription: ZIO[Any, AwsError, ProductDescription] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getInvocationPhrase: ZIO[Any, AwsError, InvocationPhrase] =
      AwsError.unwrapOptionField("invocationPhrase", invocationPhrase)
    def getReleaseDate: ZIO[Any, AwsError, ReleaseDate] =
      AwsError.unwrapOptionField("releaseDate", releaseDate)
    def getEndUserLicenseAgreement
        : ZIO[Any, AwsError, EndUserLicenseAgreement] = AwsError
      .unwrapOptionField("endUserLicenseAgreement", endUserLicenseAgreement)
    def getGenericKeywords: ZIO[Any, AwsError, List[GenericKeyword]] =
      AwsError.unwrapOptionField("genericKeywords", genericKeywords)
    def getBulletPoints: ZIO[Any, AwsError, List[BulletPoint]] =
      AwsError.unwrapOptionField("bulletPoints", bulletPoints)
    def getNewInThisVersionBulletPoints: ZIO[Any, AwsError, List[BulletPoint]] =
      AwsError.unwrapOptionField(
        "newInThisVersionBulletPoints",
        newInThisVersionBulletPoints
      )
    def getSkillTypes: ZIO[Any, AwsError, List[SkillStoreType]] =
      AwsError.unwrapOptionField("skillTypes", skillTypes)
    def getReviews: ZIO[Any, AwsError, Map[ReviewKey, ReviewValue]] =
      AwsError.unwrapOptionField("reviews", reviews)
    def getDeveloperInfo: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.DeveloperInfo.ReadOnly
    ] = AwsError.unwrapOptionField("developerInfo", developerInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SkillDetails
  ) extends zio.aws.alexaforbusiness.model.SkillDetails.ReadOnly {
    override val productDescription: Optional[ProductDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productDescription())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.ProductDescription(value)
        )
    override val invocationPhrase: Optional[InvocationPhrase] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invocationPhrase())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.InvocationPhrase(value)
        )
    override val releaseDate: Optional[ReleaseDate] = zio.aws.core.internal
      .optionalFromNullable(impl.releaseDate())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ReleaseDate(value)
      )
    override val endUserLicenseAgreement: Optional[EndUserLicenseAgreement] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endUserLicenseAgreement())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives
            .EndUserLicenseAgreement(value)
        )
    override val genericKeywords: Optional[List[GenericKeyword]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.genericKeywords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.primitives.GenericKeyword(item)
          }.toList
        )
    override val bulletPoints: Optional[List[BulletPoint]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bulletPoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.primitives.BulletPoint(item)
          }.toList
        )
    override val newInThisVersionBulletPoints: Optional[List[BulletPoint]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newInThisVersionBulletPoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.primitives.BulletPoint(item)
          }.toList
        )
    override val skillTypes: Optional[List[SkillStoreType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skillTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.primitives.SkillStoreType(item)
          }.toList
        )
    override val reviews: Optional[Map[ReviewKey, ReviewValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reviews())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.alexaforbusiness.model.primitives.ReviewKey(
                key
              ) -> zio.aws.alexaforbusiness.model.primitives.ReviewValue(value)
            })
            .toMap
        )
    override val developerInfo
        : Optional[zio.aws.alexaforbusiness.model.DeveloperInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.developerInfo())
        .map(value => zio.aws.alexaforbusiness.model.DeveloperInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SkillDetails
  ): zio.aws.alexaforbusiness.model.SkillDetails.ReadOnly = new Wrapper(impl)
}
