package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  Arn,
  ProfileName,
  ProviderCalendarId,
  RoomName,
  RoomDescription
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RoomData(
    roomArn: Optional[Arn] = Optional.Absent,
    roomName: Optional[RoomName] = Optional.Absent,
    description: Optional[RoomDescription] = Optional.Absent,
    providerCalendarId: Optional[ProviderCalendarId] = Optional.Absent,
    profileArn: Optional[Arn] = Optional.Absent,
    profileName: Optional[ProfileName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.RoomData = {
    import RoomData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.RoomData
      .builder()
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .optionallyWith(
        roomName.map(value => RoomName.unwrap(value): java.lang.String)
      )(_.roomName)
      .optionallyWith(
        description.map(value =>
          RoomDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        providerCalendarId.map(value =>
          ProviderCalendarId.unwrap(value): java.lang.String
        )
      )(_.providerCalendarId)
      .optionallyWith(
        profileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.profileArn)
      .optionallyWith(
        profileName.map(value => ProfileName.unwrap(value): java.lang.String)
      )(_.profileName)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.RoomData.ReadOnly =
    zio.aws.alexaforbusiness.model.RoomData.wrap(buildAwsValue())
}
object RoomData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.RoomData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.RoomData =
      zio.aws.alexaforbusiness.model.RoomData(
        roomArn.map(value => value),
        roomName.map(value => value),
        description.map(value => value),
        providerCalendarId.map(value => value),
        profileArn.map(value => value),
        profileName.map(value => value)
      )
    def roomArn: Optional[Arn]
    def roomName: Optional[RoomName]
    def description: Optional[RoomDescription]
    def providerCalendarId: Optional[ProviderCalendarId]
    def profileArn: Optional[Arn]
    def profileName: Optional[ProfileName]
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
    def getRoomName: ZIO[Any, AwsError, RoomName] =
      AwsError.unwrapOptionField("roomName", roomName)
    def getDescription: ZIO[Any, AwsError, RoomDescription] =
      AwsError.unwrapOptionField("description", description)
    def getProviderCalendarId: ZIO[Any, AwsError, ProviderCalendarId] =
      AwsError.unwrapOptionField("providerCalendarId", providerCalendarId)
    def getProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("profileArn", profileArn)
    def getProfileName: ZIO[Any, AwsError, ProfileName] =
      AwsError.unwrapOptionField("profileName", profileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RoomData
  ) extends zio.aws.alexaforbusiness.model.RoomData.ReadOnly {
    override val roomArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val roomName: Optional[RoomName] = zio.aws.core.internal
      .optionalFromNullable(impl.roomName())
      .map(value => zio.aws.alexaforbusiness.model.primitives.RoomName(value))
    override val description: Optional[RoomDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.RoomDescription(value)
      )
    override val providerCalendarId: Optional[ProviderCalendarId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerCalendarId())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.ProviderCalendarId(value)
        )
    override val profileArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.profileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val profileName: Optional[ProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.profileName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ProfileName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RoomData
  ): zio.aws.alexaforbusiness.model.RoomData.ReadOnly = new Wrapper(impl)
}
