package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{RoomName, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResolveRoomResponse(
    roomArn: Optional[Arn] = Optional.Absent,
    roomName: Optional[RoomName] = Optional.Absent,
    roomSkillParameters: Optional[
      Iterable[zio.aws.alexaforbusiness.model.RoomSkillParameter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse = {
    import ResolveRoomResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse
      .builder()
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .optionallyWith(
        roomName.map(value => RoomName.unwrap(value): java.lang.String)
      )(_.roomName)
      .optionallyWith(
        roomSkillParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roomSkillParameters)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.ResolveRoomResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.ResolveRoomResponse.wrap(buildAwsValue())
}
object ResolveRoomResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ResolveRoomResponse =
      zio.aws.alexaforbusiness.model.ResolveRoomResponse(
        roomArn.map(value => value),
        roomName.map(value => value),
        roomSkillParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def roomArn: Optional[Arn]
    def roomName: Optional[RoomName]
    def roomSkillParameters: Optional[
      List[zio.aws.alexaforbusiness.model.RoomSkillParameter.ReadOnly]
    ]
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
    def getRoomName: ZIO[Any, AwsError, RoomName] =
      AwsError.unwrapOptionField("roomName", roomName)
    def getRoomSkillParameters: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.RoomSkillParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("roomSkillParameters", roomSkillParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse
  ) extends zio.aws.alexaforbusiness.model.ResolveRoomResponse.ReadOnly {
    override val roomArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val roomName: Optional[RoomName] = zio.aws.core.internal
      .optionalFromNullable(impl.roomName())
      .map(value => zio.aws.alexaforbusiness.model.primitives.RoomName(value))
    override val roomSkillParameters: Optional[
      List[zio.aws.alexaforbusiness.model.RoomSkillParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.roomSkillParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.RoomSkillParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ResolveRoomResponse
  ): zio.aws.alexaforbusiness.model.ResolveRoomResponse.ReadOnly = new Wrapper(
    impl
  )
}
