package zio.aws.alexaforbusiness.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.alexaforbusiness.model.primitives.{
  SkillListMaxResults,
  NextToken,
  Arn
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSkillsRequest(
    skillGroupArn: Optional[Arn] = Optional.Absent,
    enablementType: Optional[
      zio.aws.alexaforbusiness.model.EnablementTypeFilter
    ] = Optional.Absent,
    skillType: Optional[zio.aws.alexaforbusiness.model.SkillTypeFilter] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[SkillListMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest = {
    import ListSkillsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest
      .builder()
      .optionallyWith(
        skillGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.skillGroupArn)
      .optionallyWith(enablementType.map(value => value.unwrap))(
        _.enablementType
      )
      .optionallyWith(skillType.map(value => value.unwrap))(_.skillType)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => SkillListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.ListSkillsRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.ListSkillsRequest.wrap(buildAwsValue())
}
object ListSkillsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ListSkillsRequest =
      zio.aws.alexaforbusiness.model.ListSkillsRequest(
        skillGroupArn.map(value => value),
        enablementType.map(value => value),
        skillType.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def skillGroupArn: Optional[Arn]
    def enablementType
        : Optional[zio.aws.alexaforbusiness.model.EnablementTypeFilter]
    def skillType: Optional[zio.aws.alexaforbusiness.model.SkillTypeFilter]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[SkillListMaxResults]
    def getSkillGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("skillGroupArn", skillGroupArn)
    def getEnablementType: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.EnablementTypeFilter
    ] = AwsError.unwrapOptionField("enablementType", enablementType)
    def getSkillType
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.SkillTypeFilter] =
      AwsError.unwrapOptionField("skillType", skillType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, SkillListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest
  ) extends zio.aws.alexaforbusiness.model.ListSkillsRequest.ReadOnly {
    override val skillGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.skillGroupArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val enablementType
        : Optional[zio.aws.alexaforbusiness.model.EnablementTypeFilter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablementType())
        .map(value =>
          zio.aws.alexaforbusiness.model.EnablementTypeFilter.wrap(value)
        )
    override val skillType
        : Optional[zio.aws.alexaforbusiness.model.SkillTypeFilter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skillType())
        .map(value =>
          zio.aws.alexaforbusiness.model.SkillTypeFilter.wrap(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val maxResults: Optional[SkillListMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.SkillListMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsRequest
  ): zio.aws.alexaforbusiness.model.ListSkillsRequest.ReadOnly = new Wrapper(
    impl
  )
}
