package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSkillGroupRequest(
    skillGroupArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest = {
    import GetSkillGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest
      .builder()
      .optionallyWith(
        skillGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.skillGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.GetSkillGroupRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.GetSkillGroupRequest.wrap(buildAwsValue())
}
object GetSkillGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetSkillGroupRequest =
      zio.aws.alexaforbusiness.model
        .GetSkillGroupRequest(skillGroupArn.map(value => value))
    def skillGroupArn: Optional[Arn]
    def getSkillGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("skillGroupArn", skillGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest
  ) extends zio.aws.alexaforbusiness.model.GetSkillGroupRequest.ReadOnly {
    override val skillGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.skillGroupArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetSkillGroupRequest
  ): zio.aws.alexaforbusiness.model.GetSkillGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
