package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDeviceRequest(deviceArn: Optional[Arn] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceRequest = {
    import GetDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceRequest
      .builder()
      .optionallyWith(
        deviceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.deviceArn)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.GetDeviceRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.GetDeviceRequest.wrap(buildAwsValue())
}
object GetDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetDeviceRequest =
      zio.aws.alexaforbusiness.model
        .GetDeviceRequest(deviceArn.map(value => value))
    def deviceArn: Optional[Arn]
    def getDeviceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceRequest
  ) extends zio.aws.alexaforbusiness.model.GetDeviceRequest.ReadOnly {
    override val deviceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceRequest
  ): zio.aws.alexaforbusiness.model.GetDeviceRequest.ReadOnly = new Wrapper(
    impl
  )
}
