package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait EndOfMeetingReminderType {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType
}
object EndOfMeetingReminderType {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType
  ): zio.aws.alexaforbusiness.model.EndOfMeetingReminderType = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType.ANNOUNCEMENT_TIME_CHECK =>
      val r = ANNOUNCEMENT_TIME_CHECK
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType.ANNOUNCEMENT_VARIABLE_TIME_LEFT =>
      val r = ANNOUNCEMENT_VARIABLE_TIME_LEFT
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType.CHIME =>
      val r = CHIME
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType.KNOCK =>
      val r = KNOCK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.EndOfMeetingReminderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType =
      software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType.UNKNOWN_TO_SDK_VERSION
  }
  case object ANNOUNCEMENT_TIME_CHECK
      extends zio.aws.alexaforbusiness.model.EndOfMeetingReminderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType =
      software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType.ANNOUNCEMENT_TIME_CHECK
  }
  case object ANNOUNCEMENT_VARIABLE_TIME_LEFT
      extends zio.aws.alexaforbusiness.model.EndOfMeetingReminderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType =
      software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType.ANNOUNCEMENT_VARIABLE_TIME_LEFT
  }
  case object CHIME
      extends zio.aws.alexaforbusiness.model.EndOfMeetingReminderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType =
      software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType.CHIME
  }
  case object KNOCK
      extends zio.aws.alexaforbusiness.model.EndOfMeetingReminderType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType =
      software.amazon.awssdk.services.alexaforbusiness.model.EndOfMeetingReminderType.KNOCK
  }
}
