package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteBusinessReportScheduleRequest(scheduleArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeleteBusinessReportScheduleRequest = {
    import DeleteBusinessReportScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteBusinessReportScheduleRequest
      .builder()
      .scheduleArn(Arn.unwrap(scheduleArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.DeleteBusinessReportScheduleRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DeleteBusinessReportScheduleRequest
      .wrap(buildAwsValue())
}
object DeleteBusinessReportScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteBusinessReportScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.DeleteBusinessReportScheduleRequest =
      zio.aws.alexaforbusiness.model
        .DeleteBusinessReportScheduleRequest(scheduleArn)
    def scheduleArn: Arn
    def getScheduleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(scheduleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteBusinessReportScheduleRequest
  ) extends zio.aws.alexaforbusiness.model.DeleteBusinessReportScheduleRequest.ReadOnly {
    override val scheduleArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.scheduleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteBusinessReportScheduleRequest
  ): zio.aws.alexaforbusiness.model.DeleteBusinessReportScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
