package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  ClientRequestToken,
  SkillGroupDescription,
  SkillGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSkillGroupRequest(
    skillGroupName: SkillGroupName,
    description: Optional[SkillGroupDescription] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.alexaforbusiness.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupRequest = {
    import CreateSkillGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupRequest
      .builder()
      .skillGroupName(SkillGroupName.unwrap(skillGroupName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          SkillGroupDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateSkillGroupRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateSkillGroupRequest.wrap(buildAwsValue())
}
object CreateSkillGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateSkillGroupRequest =
      zio.aws.alexaforbusiness.model.CreateSkillGroupRequest(
        skillGroupName,
        description.map(value => value),
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def skillGroupName: SkillGroupName
    def description: Optional[SkillGroupDescription]
    def clientRequestToken: Optional[ClientRequestToken]
    def tags: Optional[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]]
    def getSkillGroupName: ZIO[Any, Nothing, SkillGroupName] =
      ZIO.succeed(skillGroupName)
    def getDescription: ZIO[Any, AwsError, SkillGroupDescription] =
      AwsError.unwrapOptionField("description", description)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupRequest
  ) extends zio.aws.alexaforbusiness.model.CreateSkillGroupRequest.ReadOnly {
    override val skillGroupName: SkillGroupName =
      zio.aws.alexaforbusiness.model.primitives
        .SkillGroupName(impl.skillGroupName())
    override val description: Optional[SkillGroupDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.SkillGroupDescription(value)
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.ClientRequestToken(value)
        )
    override val tags
        : Optional[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateSkillGroupRequest
  ): zio.aws.alexaforbusiness.model.CreateSkillGroupRequest.ReadOnly =
    new Wrapper(impl)
}
