package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  ProviderCalendarId,
  RoomDescription,
  RoomName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateRoomRequest(
    roomArn: Optional[Arn] = Optional.Absent,
    roomName: Optional[RoomName] = Optional.Absent,
    description: Optional[RoomDescription] = Optional.Absent,
    providerCalendarId: Optional[ProviderCalendarId] = Optional.Absent,
    profileArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomRequest = {
    import UpdateRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomRequest
      .builder()
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .optionallyWith(
        roomName.map(value => RoomName.unwrap(value): java.lang.String)
      )(_.roomName)
      .optionallyWith(
        description.map(value =>
          RoomDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        providerCalendarId.map(value =>
          ProviderCalendarId.unwrap(value): java.lang.String
        )
      )(_.providerCalendarId)
      .optionallyWith(
        profileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.profileArn)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.UpdateRoomRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.UpdateRoomRequest.wrap(buildAwsValue())
}
object UpdateRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.UpdateRoomRequest =
      zio.aws.alexaforbusiness.model.UpdateRoomRequest(
        roomArn.map(value => value),
        roomName.map(value => value),
        description.map(value => value),
        providerCalendarId.map(value => value),
        profileArn.map(value => value)
      )
    def roomArn: Optional[Arn]
    def roomName: Optional[RoomName]
    def description: Optional[RoomDescription]
    def providerCalendarId: Optional[ProviderCalendarId]
    def profileArn: Optional[Arn]
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
    def getRoomName: ZIO[Any, AwsError, RoomName] =
      AwsError.unwrapOptionField("roomName", roomName)
    def getDescription: ZIO[Any, AwsError, RoomDescription] =
      AwsError.unwrapOptionField("description", description)
    def getProviderCalendarId: ZIO[Any, AwsError, ProviderCalendarId] =
      AwsError.unwrapOptionField("providerCalendarId", providerCalendarId)
    def getProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("profileArn", profileArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomRequest
  ) extends zio.aws.alexaforbusiness.model.UpdateRoomRequest.ReadOnly {
    override val roomArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val roomName: Optional[RoomName] = zio.aws.core.internal
      .optionalFromNullable(impl.roomName())
      .map(value => zio.aws.alexaforbusiness.model.primitives.RoomName(value))
    override val description: Optional[RoomDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.RoomDescription(value)
      )
    override val providerCalendarId: Optional[ProviderCalendarId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.providerCalendarId())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.ProviderCalendarId(value)
        )
    override val profileArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.profileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateRoomRequest
  ): zio.aws.alexaforbusiness.model.UpdateRoomRequest.ReadOnly = new Wrapper(
    impl
  )
}
