package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  AddressBookDescription,
  AddressBookName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAddressBookRequest(
    addressBookArn: Arn,
    name: Optional[AddressBookName] = Optional.Absent,
    description: Optional[AddressBookDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.UpdateAddressBookRequest = {
    import UpdateAddressBookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateAddressBookRequest
      .builder()
      .addressBookArn(Arn.unwrap(addressBookArn): java.lang.String)
      .optionallyWith(
        name.map(value => AddressBookName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          AddressBookDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.UpdateAddressBookRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.UpdateAddressBookRequest
      .wrap(buildAwsValue())
}
object UpdateAddressBookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateAddressBookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.UpdateAddressBookRequest =
      zio.aws.alexaforbusiness.model.UpdateAddressBookRequest(
        addressBookArn,
        name.map(value => value),
        description.map(value => value)
      )
    def addressBookArn: Arn
    def name: Optional[AddressBookName]
    def description: Optional[AddressBookDescription]
    def getAddressBookArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(addressBookArn)
    def getName: ZIO[Any, AwsError, AddressBookName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, AddressBookDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateAddressBookRequest
  ) extends zio.aws.alexaforbusiness.model.UpdateAddressBookRequest.ReadOnly {
    override val addressBookArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.addressBookArn())
    override val name: Optional[AddressBookName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.AddressBookName(value)
      )
    override val description: Optional[AddressBookDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives
            .AddressBookDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateAddressBookRequest
  ): zio.aws.alexaforbusiness.model.UpdateAddressBookRequest.ReadOnly =
    new Wrapper(impl)
}
