package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  RoomSkillParameterKey,
  SkillId,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRoomSkillParameterRequest(
    roomArn: Optional[Arn] = Optional.Absent,
    skillId: SkillId,
    parameterKey: RoomSkillParameterKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterRequest = {
    import GetRoomSkillParameterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterRequest
      .builder()
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .skillId(SkillId.unwrap(skillId): java.lang.String)
      .parameterKey(
        RoomSkillParameterKey.unwrap(parameterKey): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.GetRoomSkillParameterRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.GetRoomSkillParameterRequest
      .wrap(buildAwsValue())
}
object GetRoomSkillParameterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.GetRoomSkillParameterRequest =
      zio.aws.alexaforbusiness.model.GetRoomSkillParameterRequest(
        roomArn.map(value => value),
        skillId,
        parameterKey
      )
    def roomArn: Optional[Arn]
    def skillId: SkillId
    def parameterKey: RoomSkillParameterKey
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
    def getSkillId: ZIO[Any, Nothing, SkillId] = ZIO.succeed(skillId)
    def getParameterKey: ZIO[Any, Nothing, RoomSkillParameterKey] =
      ZIO.succeed(parameterKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterRequest
  ) extends zio.aws.alexaforbusiness.model.GetRoomSkillParameterRequest.ReadOnly {
    override val roomArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val skillId: SkillId =
      zio.aws.alexaforbusiness.model.primitives.SkillId(impl.skillId())
    override val parameterKey: RoomSkillParameterKey =
      zio.aws.alexaforbusiness.model.primitives
        .RoomSkillParameterKey(impl.parameterKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterRequest
  ): zio.aws.alexaforbusiness.model.GetRoomSkillParameterRequest.ReadOnly =
    new Wrapper(impl)
}
