package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteSkillGroupRequest(
    skillGroupArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupRequest = {
    import DeleteSkillGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupRequest
      .builder()
      .optionallyWith(
        skillGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.skillGroupArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.DeleteSkillGroupRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DeleteSkillGroupRequest.wrap(buildAwsValue())
}
object DeleteSkillGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeleteSkillGroupRequest =
      zio.aws.alexaforbusiness.model
        .DeleteSkillGroupRequest(skillGroupArn.map(value => value))
    def skillGroupArn: Optional[Arn]
    def getSkillGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("skillGroupArn", skillGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupRequest
  ) extends zio.aws.alexaforbusiness.model.DeleteSkillGroupRequest.ReadOnly {
    override val skillGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.skillGroupArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteSkillGroupRequest
  ): zio.aws.alexaforbusiness.model.DeleteSkillGroupRequest.ReadOnly =
    new Wrapper(impl)
}
