package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteGatewayGroupRequest(gatewayGroupArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeleteGatewayGroupRequest = {
    import DeleteGatewayGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteGatewayGroupRequest
      .builder()
      .gatewayGroupArn(Arn.unwrap(gatewayGroupArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.DeleteGatewayGroupRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DeleteGatewayGroupRequest
      .wrap(buildAwsValue())
}
object DeleteGatewayGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteGatewayGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeleteGatewayGroupRequest =
      zio.aws.alexaforbusiness.model.DeleteGatewayGroupRequest(gatewayGroupArn)
    def gatewayGroupArn: Arn
    def getGatewayGroupArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(gatewayGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteGatewayGroupRequest
  ) extends zio.aws.alexaforbusiness.model.DeleteGatewayGroupRequest.ReadOnly {
    override val gatewayGroupArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.gatewayGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteGatewayGroupRequest
  ): zio.aws.alexaforbusiness.model.DeleteGatewayGroupRequest.ReadOnly =
    new Wrapper(impl)
}
