package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateUserResponse(userArn: Optional[Arn] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateUserResponse = {
    import CreateUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateUserResponse
      .builder()
      .optionallyWith(
        userArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.userArn)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.CreateUserResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateUserResponse.wrap(buildAwsValue())
}
object CreateUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateUserResponse =
      zio.aws.alexaforbusiness.model
        .CreateUserResponse(userArn.map(value => value))
    def userArn: Optional[Arn]
    def getUserArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("userArn", userArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateUserResponse
  ) extends zio.aws.alexaforbusiness.model.CreateUserResponse.ReadOnly {
    override val userArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.userArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateUserResponse
  ): zio.aws.alexaforbusiness.model.CreateUserResponse.ReadOnly = new Wrapper(
    impl
  )
}
