package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateGatewayGroupResponse(
    gatewayGroupArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupResponse = {
    import CreateGatewayGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupResponse
      .builder()
      .optionallyWith(
        gatewayGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.gatewayGroupArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateGatewayGroupResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateGatewayGroupResponse
      .wrap(buildAwsValue())
}
object CreateGatewayGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateGatewayGroupResponse =
      zio.aws.alexaforbusiness.model
        .CreateGatewayGroupResponse(gatewayGroupArn.map(value => value))
    def gatewayGroupArn: Optional[Arn]
    def getGatewayGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("gatewayGroupArn", gatewayGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupResponse
  ) extends zio.aws.alexaforbusiness.model.CreateGatewayGroupResponse.ReadOnly {
    override val gatewayGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayGroupArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateGatewayGroupResponse
  ): zio.aws.alexaforbusiness.model.CreateGatewayGroupResponse.ReadOnly =
    new Wrapper(impl)
}
