package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Content(
    textList: Optional[Iterable[zio.aws.alexaforbusiness.model.Text]] =
      Optional.Absent,
    ssmlList: Optional[Iterable[zio.aws.alexaforbusiness.model.Ssml]] =
      Optional.Absent,
    audioList: Optional[Iterable[zio.aws.alexaforbusiness.model.Audio]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.Content = {
    import Content.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.Content
      .builder()
      .optionallyWith(
        textList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.textList)
      .optionallyWith(
        ssmlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ssmlList)
      .optionallyWith(
        audioList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.audioList)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.Content.ReadOnly =
    zio.aws.alexaforbusiness.model.Content.wrap(buildAwsValue())
}
object Content {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.Content
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.Content =
      zio.aws.alexaforbusiness.model.Content(
        textList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ssmlList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        audioList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def textList: Optional[List[zio.aws.alexaforbusiness.model.Text.ReadOnly]]
    def ssmlList: Optional[List[zio.aws.alexaforbusiness.model.Ssml.ReadOnly]]
    def audioList: Optional[List[zio.aws.alexaforbusiness.model.Audio.ReadOnly]]
    def getTextList: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Text.ReadOnly
    ]] = AwsError.unwrapOptionField("textList", textList)
    def getSsmlList: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Ssml.ReadOnly
    ]] = AwsError.unwrapOptionField("ssmlList", ssmlList)
    def getAudioList: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Audio.ReadOnly
    ]] = AwsError.unwrapOptionField("audioList", audioList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Content
  ) extends zio.aws.alexaforbusiness.model.Content.ReadOnly {
    override val textList
        : Optional[List[zio.aws.alexaforbusiness.model.Text.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.Text.wrap(item)
          }.toList
        )
    override val ssmlList
        : Optional[List[zio.aws.alexaforbusiness.model.Ssml.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssmlList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.Ssml.wrap(item)
          }.toList
        )
    override val audioList
        : Optional[List[zio.aws.alexaforbusiness.model.Audio.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.audioList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.Audio.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Content
  ): zio.aws.alexaforbusiness.model.Content.ReadOnly = new Wrapper(impl)
}
