package zio.aws.alexaforbusiness.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.alexaforbusiness.model.primitives.{
  BusinessReportDownloadUrl,
  BusinessReportDeliveryTime
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class BusinessReport(
    status: Optional[zio.aws.alexaforbusiness.model.BusinessReportStatus] =
      Optional.Absent,
    failureCode: Optional[
      zio.aws.alexaforbusiness.model.BusinessReportFailureCode
    ] = Optional.Absent,
    s3Location: Optional[
      zio.aws.alexaforbusiness.model.BusinessReportS3Location
    ] = Optional.Absent,
    deliveryTime: Optional[BusinessReportDeliveryTime] = Optional.Absent,
    downloadUrl: Optional[BusinessReportDownloadUrl] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReport = {
    import BusinessReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.BusinessReport
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .optionallyWith(
        deliveryTime.map(value =>
          BusinessReportDeliveryTime.unwrap(value): Instant
        )
      )(_.deliveryTime)
      .optionallyWith(
        downloadUrl.map(value =>
          BusinessReportDownloadUrl.unwrap(value): java.lang.String
        )
      )(_.downloadUrl)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.BusinessReport.ReadOnly =
    zio.aws.alexaforbusiness.model.BusinessReport.wrap(buildAwsValue())
}
object BusinessReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.BusinessReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.BusinessReport =
      zio.aws.alexaforbusiness.model.BusinessReport(
        status.map(value => value),
        failureCode.map(value => value),
        s3Location.map(value => value.asEditable),
        deliveryTime.map(value => value),
        downloadUrl.map(value => value)
      )
    def status: Optional[zio.aws.alexaforbusiness.model.BusinessReportStatus]
    def failureCode
        : Optional[zio.aws.alexaforbusiness.model.BusinessReportFailureCode]
    def s3Location: Optional[
      zio.aws.alexaforbusiness.model.BusinessReportS3Location.ReadOnly
    ]
    def deliveryTime: Optional[BusinessReportDeliveryTime]
    def downloadUrl: Optional[BusinessReportDownloadUrl]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.BusinessReportStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getFailureCode: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.BusinessReportFailureCode
    ] = AwsError.unwrapOptionField("failureCode", failureCode)
    def getS3Location: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.BusinessReportS3Location.ReadOnly
    ] = AwsError.unwrapOptionField("s3Location", s3Location)
    def getDeliveryTime: ZIO[Any, AwsError, BusinessReportDeliveryTime] =
      AwsError.unwrapOptionField("deliveryTime", deliveryTime)
    def getDownloadUrl: ZIO[Any, AwsError, BusinessReportDownloadUrl] =
      AwsError.unwrapOptionField("downloadUrl", downloadUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReport
  ) extends zio.aws.alexaforbusiness.model.BusinessReport.ReadOnly {
    override val status
        : Optional[zio.aws.alexaforbusiness.model.BusinessReportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.alexaforbusiness.model.BusinessReportStatus.wrap(value)
        )
    override val failureCode
        : Optional[zio.aws.alexaforbusiness.model.BusinessReportFailureCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureCode())
        .map(value =>
          zio.aws.alexaforbusiness.model.BusinessReportFailureCode.wrap(value)
        )
    override val s3Location: Optional[
      zio.aws.alexaforbusiness.model.BusinessReportS3Location.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Location())
      .map(value =>
        zio.aws.alexaforbusiness.model.BusinessReportS3Location.wrap(value)
      )
    override val deliveryTime: Optional[BusinessReportDeliveryTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryTime())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives
            .BusinessReportDeliveryTime(value)
        )
    override val downloadUrl: Optional[BusinessReportDownloadUrl] =
      zio.aws.core.internal
        .optionalFromNullable(impl.downloadUrl())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives
            .BusinessReportDownloadUrl(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReport
  ): zio.aws.alexaforbusiness.model.BusinessReport.ReadOnly = new Wrapper(impl)
}
