package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.AudioLocation
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Audio(
    locale: zio.aws.alexaforbusiness.model.Locale,
    location: AudioLocation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.Audio = {
    import Audio.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.Audio
      .builder()
      .locale(locale.unwrap)
      .location(AudioLocation.unwrap(location): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.Audio.ReadOnly =
    zio.aws.alexaforbusiness.model.Audio.wrap(buildAwsValue())
}
object Audio {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.Audio
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.Audio =
      zio.aws.alexaforbusiness.model.Audio(locale, location)
    def locale: zio.aws.alexaforbusiness.model.Locale
    def location: AudioLocation
    def getLocale: ZIO[Any, Nothing, zio.aws.alexaforbusiness.model.Locale] =
      ZIO.succeed(locale)
    def getLocation: ZIO[Any, Nothing, AudioLocation] = ZIO.succeed(location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Audio
  ) extends zio.aws.alexaforbusiness.model.Audio.ReadOnly {
    override val locale: zio.aws.alexaforbusiness.model.Locale =
      zio.aws.alexaforbusiness.model.Locale.wrap(impl.locale())
    override val location: AudioLocation =
      zio.aws.alexaforbusiness.model.primitives.AudioLocation(impl.location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Audio
  ): zio.aws.alexaforbusiness.model.Audio.ReadOnly = new Wrapper(impl)
}
