package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  Arn,
  EnrollmentId,
  Email,
  User_LastName,
  User_FirstName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UserData(
    userArn: Optional[Arn] = Optional.Absent,
    firstName: Optional[User_FirstName] = Optional.Absent,
    lastName: Optional[User_LastName] = Optional.Absent,
    email: Optional[Email] = Optional.Absent,
    enrollmentStatus: Optional[
      zio.aws.alexaforbusiness.model.EnrollmentStatus
    ] = Optional.Absent,
    enrollmentId: Optional[EnrollmentId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.UserData = {
    import UserData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.UserData
      .builder()
      .optionallyWith(
        userArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.userArn)
      .optionallyWith(
        firstName.map(value => User_FirstName.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => User_LastName.unwrap(value): java.lang.String)
      )(_.lastName)
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(enrollmentStatus.map(value => value.unwrap))(
        _.enrollmentStatus
      )
      .optionallyWith(
        enrollmentId.map(value => EnrollmentId.unwrap(value): java.lang.String)
      )(_.enrollmentId)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.UserData.ReadOnly =
    zio.aws.alexaforbusiness.model.UserData.wrap(buildAwsValue())
}
object UserData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.UserData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.UserData =
      zio.aws.alexaforbusiness.model.UserData(
        userArn.map(value => value),
        firstName.map(value => value),
        lastName.map(value => value),
        email.map(value => value),
        enrollmentStatus.map(value => value),
        enrollmentId.map(value => value)
      )
    def userArn: Optional[Arn]
    def firstName: Optional[User_FirstName]
    def lastName: Optional[User_LastName]
    def email: Optional[Email]
    def enrollmentStatus
        : Optional[zio.aws.alexaforbusiness.model.EnrollmentStatus]
    def enrollmentId: Optional[EnrollmentId]
    def getUserArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("userArn", userArn)
    def getFirstName: ZIO[Any, AwsError, User_FirstName] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, User_LastName] =
      AwsError.unwrapOptionField("lastName", lastName)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
    def getEnrollmentStatus
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.EnrollmentStatus] =
      AwsError.unwrapOptionField("enrollmentStatus", enrollmentStatus)
    def getEnrollmentId: ZIO[Any, AwsError, EnrollmentId] =
      AwsError.unwrapOptionField("enrollmentId", enrollmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UserData
  ) extends zio.aws.alexaforbusiness.model.UserData.ReadOnly {
    override val userArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.userArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val firstName: Optional[User_FirstName] = zio.aws.core.internal
      .optionalFromNullable(impl.firstName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.User_FirstName(value)
      )
    override val lastName: Optional[User_LastName] = zio.aws.core.internal
      .optionalFromNullable(impl.lastName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.User_LastName(value)
      )
    override val email: Optional[Email] = zio.aws.core.internal
      .optionalFromNullable(impl.email())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Email(value))
    override val enrollmentStatus
        : Optional[zio.aws.alexaforbusiness.model.EnrollmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enrollmentStatus())
        .map(value =>
          zio.aws.alexaforbusiness.model.EnrollmentStatus.wrap(value)
        )
    override val enrollmentId: Optional[EnrollmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.enrollmentId())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.EnrollmentId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UserData
  ): zio.aws.alexaforbusiness.model.UserData.ReadOnly = new Wrapper(impl)
}
