package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{DeviceName, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDeviceRequest(
    deviceArn: Optional[Arn] = Optional.Absent,
    deviceName: Optional[DeviceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceRequest = {
    import UpdateDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceRequest
      .builder()
      .optionallyWith(
        deviceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.deviceArn)
      .optionallyWith(
        deviceName.map(value => DeviceName.unwrap(value): java.lang.String)
      )(_.deviceName)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.UpdateDeviceRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.UpdateDeviceRequest.wrap(buildAwsValue())
}
object UpdateDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.UpdateDeviceRequest =
      zio.aws.alexaforbusiness.model.UpdateDeviceRequest(
        deviceArn.map(value => value),
        deviceName.map(value => value)
      )
    def deviceArn: Optional[Arn]
    def deviceName: Optional[DeviceName]
    def getDeviceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
    def getDeviceName: ZIO[Any, AwsError, DeviceName] =
      AwsError.unwrapOptionField("deviceName", deviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceRequest
  ) extends zio.aws.alexaforbusiness.model.UpdateDeviceRequest.ReadOnly {
    override val deviceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val deviceName: Optional[DeviceName] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => zio.aws.alexaforbusiness.model.primitives.DeviceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateDeviceRequest
  ): zio.aws.alexaforbusiness.model.UpdateDeviceRequest.ReadOnly = new Wrapper(
    impl
  )
}
