package zio.aws.alexaforbusiness.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.alexaforbusiness.model.primitives.{TotalCount, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchContactsResponse(
    contacts: Optional[Iterable[zio.aws.alexaforbusiness.model.ContactData]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    totalCount: Optional[TotalCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse = {
    import SearchContactsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse
      .builder()
      .optionallyWith(
        contacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contacts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        totalCount.map(value => TotalCount.unwrap(value): Integer)
      )(_.totalCount)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.SearchContactsResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.SearchContactsResponse.wrap(buildAwsValue())
}
object SearchContactsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SearchContactsResponse =
      zio.aws.alexaforbusiness.model.SearchContactsResponse(
        contacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        totalCount.map(value => value)
      )
    def contacts
        : Optional[List[zio.aws.alexaforbusiness.model.ContactData.ReadOnly]]
    def nextToken: Optional[NextToken]
    def totalCount: Optional[TotalCount]
    def getContacts: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.ContactData.ReadOnly
    ]] = AwsError.unwrapOptionField("contacts", contacts)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTotalCount: ZIO[Any, AwsError, TotalCount] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse
  ) extends zio.aws.alexaforbusiness.model.SearchContactsResponse.ReadOnly {
    override val contacts
        : Optional[List[zio.aws.alexaforbusiness.model.ContactData.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.ContactData.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val totalCount: Optional[TotalCount] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => zio.aws.alexaforbusiness.model.primitives.TotalCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchContactsResponse
  ): zio.aws.alexaforbusiness.model.SearchContactsResponse.ReadOnly =
    new Wrapper(impl)
}
