package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.SkillId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RejectSkillRequest(skillId: SkillId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.RejectSkillRequest = {
    import RejectSkillRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.RejectSkillRequest
      .builder()
      .skillId(SkillId.unwrap(skillId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.RejectSkillRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.RejectSkillRequest.wrap(buildAwsValue())
}
object RejectSkillRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.RejectSkillRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.RejectSkillRequest =
      zio.aws.alexaforbusiness.model.RejectSkillRequest(skillId)
    def skillId: SkillId
    def getSkillId: ZIO[Any, Nothing, SkillId] = ZIO.succeed(skillId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RejectSkillRequest
  ) extends zio.aws.alexaforbusiness.model.RejectSkillRequest.ReadOnly {
    override val skillId: SkillId =
      zio.aws.alexaforbusiness.model.primitives.SkillId(impl.skillId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RejectSkillRequest
  ): zio.aws.alexaforbusiness.model.RejectSkillRequest.ReadOnly = new Wrapper(
    impl
  )
}
