package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  OneClickPinDelay,
  OneClickIdDelay,
  OutboundPhoneNumber,
  CountryCode
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PSTNDialIn(
    countryCode: CountryCode,
    phoneNumber: OutboundPhoneNumber,
    oneClickIdDelay: OneClickIdDelay,
    oneClickPinDelay: OneClickPinDelay
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.PSTNDialIn = {
    import PSTNDialIn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.PSTNDialIn
      .builder()
      .countryCode(CountryCode.unwrap(countryCode): java.lang.String)
      .phoneNumber(OutboundPhoneNumber.unwrap(phoneNumber): java.lang.String)
      .oneClickIdDelay(
        OneClickIdDelay.unwrap(oneClickIdDelay): java.lang.String
      )
      .oneClickPinDelay(
        OneClickPinDelay.unwrap(oneClickPinDelay): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.PSTNDialIn.ReadOnly =
    zio.aws.alexaforbusiness.model.PSTNDialIn.wrap(buildAwsValue())
}
object PSTNDialIn {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.PSTNDialIn
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.PSTNDialIn =
      zio.aws.alexaforbusiness.model.PSTNDialIn(
        countryCode,
        phoneNumber,
        oneClickIdDelay,
        oneClickPinDelay
      )
    def countryCode: CountryCode
    def phoneNumber: OutboundPhoneNumber
    def oneClickIdDelay: OneClickIdDelay
    def oneClickPinDelay: OneClickPinDelay
    def getCountryCode: ZIO[Any, Nothing, CountryCode] =
      ZIO.succeed(countryCode)
    def getPhoneNumber: ZIO[Any, Nothing, OutboundPhoneNumber] =
      ZIO.succeed(phoneNumber)
    def getOneClickIdDelay: ZIO[Any, Nothing, OneClickIdDelay] =
      ZIO.succeed(oneClickIdDelay)
    def getOneClickPinDelay: ZIO[Any, Nothing, OneClickPinDelay] =
      ZIO.succeed(oneClickPinDelay)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.PSTNDialIn
  ) extends zio.aws.alexaforbusiness.model.PSTNDialIn.ReadOnly {
    override val countryCode: CountryCode =
      zio.aws.alexaforbusiness.model.primitives.CountryCode(impl.countryCode())
    override val phoneNumber: OutboundPhoneNumber =
      zio.aws.alexaforbusiness.model.primitives
        .OutboundPhoneNumber(impl.phoneNumber())
    override val oneClickIdDelay: OneClickIdDelay =
      zio.aws.alexaforbusiness.model.primitives
        .OneClickIdDelay(impl.oneClickIdDelay())
    override val oneClickPinDelay: OneClickPinDelay =
      zio.aws.alexaforbusiness.model.primitives
        .OneClickPinDelay(impl.oneClickPinDelay())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.PSTNDialIn
  ): zio.aws.alexaforbusiness.model.PSTNDialIn.ReadOnly = new Wrapper(impl)
}
