package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Endpoint
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class IPDialIn(
    endpoint: Endpoint,
    commsProtocol: zio.aws.alexaforbusiness.model.CommsProtocol
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.IPDialIn = {
    import IPDialIn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.IPDialIn
      .builder()
      .endpoint(Endpoint.unwrap(endpoint): java.lang.String)
      .commsProtocol(commsProtocol.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.IPDialIn.ReadOnly =
    zio.aws.alexaforbusiness.model.IPDialIn.wrap(buildAwsValue())
}
object IPDialIn {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.IPDialIn
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.IPDialIn =
      zio.aws.alexaforbusiness.model.IPDialIn(endpoint, commsProtocol)
    def endpoint: Endpoint
    def commsProtocol: zio.aws.alexaforbusiness.model.CommsProtocol
    def getEndpoint: ZIO[Any, Nothing, Endpoint] = ZIO.succeed(endpoint)
    def getCommsProtocol
        : ZIO[Any, Nothing, zio.aws.alexaforbusiness.model.CommsProtocol] =
      ZIO.succeed(commsProtocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.IPDialIn
  ) extends zio.aws.alexaforbusiness.model.IPDialIn.ReadOnly {
    override val endpoint: Endpoint =
      zio.aws.alexaforbusiness.model.primitives.Endpoint(impl.endpoint())
    override val commsProtocol: zio.aws.alexaforbusiness.model.CommsProtocol =
      zio.aws.alexaforbusiness.model.CommsProtocol.wrap(impl.commsProtocol())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.IPDialIn
  ): zio.aws.alexaforbusiness.model.IPDialIn.ReadOnly = new Wrapper(impl)
}
