package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRoomSkillParameterResponse(
    roomSkillParameter: Optional[
      zio.aws.alexaforbusiness.model.RoomSkillParameter
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterResponse = {
    import GetRoomSkillParameterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterResponse
      .builder()
      .optionallyWith(roomSkillParameter.map(value => value.buildAwsValue()))(
        _.roomSkillParameter
      )
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.GetRoomSkillParameterResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.GetRoomSkillParameterResponse
      .wrap(buildAwsValue())
}
object GetRoomSkillParameterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.GetRoomSkillParameterResponse =
      zio.aws.alexaforbusiness.model.GetRoomSkillParameterResponse(
        roomSkillParameter.map(value => value.asEditable)
      )
    def roomSkillParameter
        : Optional[zio.aws.alexaforbusiness.model.RoomSkillParameter.ReadOnly]
    def getRoomSkillParameter: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.RoomSkillParameter.ReadOnly
    ] = AwsError.unwrapOptionField("roomSkillParameter", roomSkillParameter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterResponse
  ) extends zio.aws.alexaforbusiness.model.GetRoomSkillParameterResponse.ReadOnly {
    override val roomSkillParameter
        : Optional[zio.aws.alexaforbusiness.model.RoomSkillParameter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roomSkillParameter())
        .map(value =>
          zio.aws.alexaforbusiness.model.RoomSkillParameter.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetRoomSkillParameterResponse
  ): zio.aws.alexaforbusiness.model.GetRoomSkillParameterResponse.ReadOnly =
    new Wrapper(impl)
}
