package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{FilterValue, FilterKey}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Filter(key: FilterKey, values: Iterable[FilterValue]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.Filter
      .builder()
      .key(FilterKey.unwrap(key): java.lang.String)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.Filter.ReadOnly =
    zio.aws.alexaforbusiness.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.Filter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.Filter =
      zio.aws.alexaforbusiness.model.Filter(key, values)
    def key: FilterKey
    def values: List[FilterValue]
    def getKey: ZIO[Any, Nothing, FilterKey] = ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Filter
  ) extends zio.aws.alexaforbusiness.model.Filter.ReadOnly {
    override val key: FilterKey =
      zio.aws.alexaforbusiness.model.primitives.FilterKey(impl.key())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.alexaforbusiness.model.primitives.FilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Filter
  ): zio.aws.alexaforbusiness.model.Filter.ReadOnly = new Wrapper(impl)
}
