package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait BusinessReportFailureCode {
  def unwrap: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFailureCode
}
object BusinessReportFailureCode {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFailureCode
  ): zio.aws.alexaforbusiness.model.BusinessReportFailureCode = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFailureCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFailureCode.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFailureCode.NO_SUCH_BUCKET =>
      val r = NO_SUCH_BUCKET
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFailureCode.INTERNAL_FAILURE =>
      val r = INTERNAL_FAILURE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.BusinessReportFailureCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFailureCode =
      software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFailureCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCESS_DENIED
      extends zio.aws.alexaforbusiness.model.BusinessReportFailureCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFailureCode =
      software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFailureCode.ACCESS_DENIED
  }
  case object NO_SUCH_BUCKET
      extends zio.aws.alexaforbusiness.model.BusinessReportFailureCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFailureCode =
      software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFailureCode.NO_SUCH_BUCKET
  }
  case object INTERNAL_FAILURE
      extends zio.aws.alexaforbusiness.model.BusinessReportFailureCode {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFailureCode =
      software.amazon.awssdk.services.alexaforbusiness.model.BusinessReportFailureCode.INTERNAL_FAILURE
  }
}
