package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  Arn,
  NextWiFiPassword,
  NetworkProfileDescription,
  TrustAnchor,
  CurrentWiFiPassword,
  NetworkProfileName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateNetworkProfileRequest(
    networkProfileArn: Arn,
    networkProfileName: Optional[NetworkProfileName] = Optional.Absent,
    description: Optional[NetworkProfileDescription] = Optional.Absent,
    currentPassword: Optional[CurrentWiFiPassword] = Optional.Absent,
    nextPassword: Optional[NextWiFiPassword] = Optional.Absent,
    certificateAuthorityArn: Optional[Arn] = Optional.Absent,
    trustAnchors: Optional[Iterable[TrustAnchor]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.UpdateNetworkProfileRequest = {
    import UpdateNetworkProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateNetworkProfileRequest
      .builder()
      .networkProfileArn(Arn.unwrap(networkProfileArn): java.lang.String)
      .optionallyWith(
        networkProfileName.map(value =>
          NetworkProfileName.unwrap(value): java.lang.String
        )
      )(_.networkProfileName)
      .optionallyWith(
        description.map(value =>
          NetworkProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        currentPassword.map(value =>
          CurrentWiFiPassword.unwrap(value): java.lang.String
        )
      )(_.currentPassword)
      .optionallyWith(
        nextPassword.map(value =>
          NextWiFiPassword.unwrap(value): java.lang.String
        )
      )(_.nextPassword)
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .optionallyWith(
        trustAnchors.map(value =>
          value.map { item =>
            TrustAnchor.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.trustAnchors)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.UpdateNetworkProfileRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.UpdateNetworkProfileRequest
      .wrap(buildAwsValue())
}
object UpdateNetworkProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateNetworkProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.UpdateNetworkProfileRequest =
      zio.aws.alexaforbusiness.model.UpdateNetworkProfileRequest(
        networkProfileArn,
        networkProfileName.map(value => value),
        description.map(value => value),
        currentPassword.map(value => value),
        nextPassword.map(value => value),
        certificateAuthorityArn.map(value => value),
        trustAnchors.map(value => value)
      )
    def networkProfileArn: Arn
    def networkProfileName: Optional[NetworkProfileName]
    def description: Optional[NetworkProfileDescription]
    def currentPassword: Optional[CurrentWiFiPassword]
    def nextPassword: Optional[NextWiFiPassword]
    def certificateAuthorityArn: Optional[Arn]
    def trustAnchors: Optional[List[TrustAnchor]]
    def getNetworkProfileArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(networkProfileArn)
    def getNetworkProfileName: ZIO[Any, AwsError, NetworkProfileName] =
      AwsError.unwrapOptionField("networkProfileName", networkProfileName)
    def getDescription: ZIO[Any, AwsError, NetworkProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCurrentPassword: ZIO[Any, AwsError, CurrentWiFiPassword] =
      AwsError.unwrapOptionField("currentPassword", currentPassword)
    def getNextPassword: ZIO[Any, AwsError, NextWiFiPassword] =
      AwsError.unwrapOptionField("nextPassword", nextPassword)
    def getCertificateAuthorityArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("certificateAuthorityArn", certificateAuthorityArn)
    def getTrustAnchors: ZIO[Any, AwsError, List[TrustAnchor]] =
      AwsError.unwrapOptionField("trustAnchors", trustAnchors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateNetworkProfileRequest
  ) extends zio.aws.alexaforbusiness.model.UpdateNetworkProfileRequest.ReadOnly {
    override val networkProfileArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.networkProfileArn())
    override val networkProfileName: Optional[NetworkProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkProfileName())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.NetworkProfileName(value)
        )
    override val description: Optional[NetworkProfileDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives
            .NetworkProfileDescription(value)
        )
    override val currentPassword: Optional[CurrentWiFiPassword] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentPassword())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.CurrentWiFiPassword(value)
        )
    override val nextPassword: Optional[NextWiFiPassword] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextPassword())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.NextWiFiPassword(value)
        )
    override val certificateAuthorityArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateAuthorityArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val trustAnchors: Optional[List[TrustAnchor]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trustAnchors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.primitives.TrustAnchor(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateNetworkProfileRequest
  ): zio.aws.alexaforbusiness.model.UpdateNetworkProfileRequest.ReadOnly =
    new Wrapper(impl)
}
