package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  GatewayVersion,
  GatewayDescription,
  GatewayName,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateGatewayRequest(
    gatewayArn: Arn,
    name: Optional[GatewayName] = Optional.Absent,
    description: Optional[GatewayDescription] = Optional.Absent,
    softwareVersion: Optional[GatewayVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayRequest = {
    import UpdateGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayRequest
      .builder()
      .gatewayArn(Arn.unwrap(gatewayArn): java.lang.String)
      .optionallyWith(
        name.map(value => GatewayName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          GatewayDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        softwareVersion.map(value =>
          GatewayVersion.unwrap(value): java.lang.String
        )
      )(_.softwareVersion)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.UpdateGatewayRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.UpdateGatewayRequest.wrap(buildAwsValue())
}
object UpdateGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.UpdateGatewayRequest =
      zio.aws.alexaforbusiness.model.UpdateGatewayRequest(
        gatewayArn,
        name.map(value => value),
        description.map(value => value),
        softwareVersion.map(value => value)
      )
    def gatewayArn: Arn
    def name: Optional[GatewayName]
    def description: Optional[GatewayDescription]
    def softwareVersion: Optional[GatewayVersion]
    def getGatewayArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(gatewayArn)
    def getName: ZIO[Any, AwsError, GatewayName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, GatewayDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSoftwareVersion: ZIO[Any, AwsError, GatewayVersion] =
      AwsError.unwrapOptionField("softwareVersion", softwareVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayRequest
  ) extends zio.aws.alexaforbusiness.model.UpdateGatewayRequest.ReadOnly {
    override val gatewayArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.gatewayArn())
    override val name: Optional[GatewayName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.GatewayName(value)
      )
    override val description: Optional[GatewayDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.GatewayDescription(value)
        )
    override val softwareVersion: Optional[GatewayVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.softwareVersion())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.GatewayVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateGatewayRequest
  ): zio.aws.alexaforbusiness.model.UpdateGatewayRequest.ReadOnly = new Wrapper(
    impl
  )
}
