package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    arn: Arn,
    tags: Iterable[zio.aws.alexaforbusiness.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.TagResourceRequest
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.TagResourceRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.TagResourceRequest =
      zio.aws.alexaforbusiness.model.TagResourceRequest(
        arn,
        tags.map { item =>
          item.asEditable
        }
      )
    def arn: Arn
    def tags: List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.TagResourceRequest
  ) extends zio.aws.alexaforbusiness.model.TagResourceRequest.ReadOnly {
    override val arn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.arn())
    override val tags: List[zio.aws.alexaforbusiness.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.alexaforbusiness.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.TagResourceRequest
  ): zio.aws.alexaforbusiness.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
