package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  ApplianceManufacturerName,
  ApplianceDescription,
  ApplianceFriendlyName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SmartHomeAppliance(
    friendlyName: Optional[ApplianceFriendlyName] = Optional.Absent,
    description: Optional[ApplianceDescription] = Optional.Absent,
    manufacturerName: Optional[ApplianceManufacturerName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SmartHomeAppliance = {
    import SmartHomeAppliance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SmartHomeAppliance
      .builder()
      .optionallyWith(
        friendlyName.map(value =>
          ApplianceFriendlyName.unwrap(value): java.lang.String
        )
      )(_.friendlyName)
      .optionallyWith(
        description.map(value =>
          ApplianceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        manufacturerName.map(value =>
          ApplianceManufacturerName.unwrap(value): java.lang.String
        )
      )(_.manufacturerName)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.SmartHomeAppliance.ReadOnly =
    zio.aws.alexaforbusiness.model.SmartHomeAppliance.wrap(buildAwsValue())
}
object SmartHomeAppliance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SmartHomeAppliance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SmartHomeAppliance =
      zio.aws.alexaforbusiness.model.SmartHomeAppliance(
        friendlyName.map(value => value),
        description.map(value => value),
        manufacturerName.map(value => value)
      )
    def friendlyName: Optional[ApplianceFriendlyName]
    def description: Optional[ApplianceDescription]
    def manufacturerName: Optional[ApplianceManufacturerName]
    def getFriendlyName: ZIO[Any, AwsError, ApplianceFriendlyName] =
      AwsError.unwrapOptionField("friendlyName", friendlyName)
    def getDescription: ZIO[Any, AwsError, ApplianceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getManufacturerName: ZIO[Any, AwsError, ApplianceManufacturerName] =
      AwsError.unwrapOptionField("manufacturerName", manufacturerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SmartHomeAppliance
  ) extends zio.aws.alexaforbusiness.model.SmartHomeAppliance.ReadOnly {
    override val friendlyName: Optional[ApplianceFriendlyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.friendlyName())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.ApplianceFriendlyName(value)
        )
    override val description: Optional[ApplianceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.ApplianceDescription(value)
        )
    override val manufacturerName: Optional[ApplianceManufacturerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manufacturerName())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives
            .ApplianceManufacturerName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SmartHomeAppliance
  ): zio.aws.alexaforbusiness.model.SmartHomeAppliance.ReadOnly = new Wrapper(
    impl
  )
}
