package zio.aws.alexaforbusiness.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.alexaforbusiness.model.primitives.{TotalCount, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchDevicesResponse(
    devices: Optional[Iterable[zio.aws.alexaforbusiness.model.DeviceData]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    totalCount: Optional[TotalCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse = {
    import SearchDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse
      .builder()
      .optionallyWith(
        devices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.devices)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        totalCount.map(value => TotalCount.unwrap(value): Integer)
      )(_.totalCount)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.SearchDevicesResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.SearchDevicesResponse.wrap(buildAwsValue())
}
object SearchDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SearchDevicesResponse =
      zio.aws.alexaforbusiness.model.SearchDevicesResponse(
        devices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        totalCount.map(value => value)
      )
    def devices
        : Optional[List[zio.aws.alexaforbusiness.model.DeviceData.ReadOnly]]
    def nextToken: Optional[NextToken]
    def totalCount: Optional[TotalCount]
    def getDevices: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.DeviceData.ReadOnly
    ]] = AwsError.unwrapOptionField("devices", devices)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTotalCount: ZIO[Any, AwsError, TotalCount] =
      AwsError.unwrapOptionField("totalCount", totalCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse
  ) extends zio.aws.alexaforbusiness.model.SearchDevicesResponse.ReadOnly {
    override val devices
        : Optional[List[zio.aws.alexaforbusiness.model.DeviceData.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.devices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.DeviceData.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val totalCount: Optional[TotalCount] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => zio.aws.alexaforbusiness.model.primitives.TotalCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SearchDevicesResponse
  ): zio.aws.alexaforbusiness.model.SearchDevicesResponse.ReadOnly =
    new Wrapper(impl)
}
