package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSkillsResponse(
    skillSummaries: Optional[
      Iterable[zio.aws.alexaforbusiness.model.SkillSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse = {
    import ListSkillsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse
      .builder()
      .optionallyWith(
        skillSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.skillSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.ListSkillsResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.ListSkillsResponse.wrap(buildAwsValue())
}
object ListSkillsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ListSkillsResponse =
      zio.aws.alexaforbusiness.model.ListSkillsResponse(
        skillSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def skillSummaries
        : Optional[List[zio.aws.alexaforbusiness.model.SkillSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSkillSummaries: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.SkillSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("skillSummaries", skillSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse
  ) extends zio.aws.alexaforbusiness.model.ListSkillsResponse.ReadOnly {
    override val skillSummaries
        : Optional[List[zio.aws.alexaforbusiness.model.SkillSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skillSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.alexaforbusiness.model.SkillSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListSkillsResponse
  ): zio.aws.alexaforbusiness.model.ListSkillsResponse.ReadOnly = new Wrapper(
    impl
  )
}
