package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.SkillId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisassociateSkillFromUsersRequest(skillId: SkillId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromUsersRequest = {
    import DisassociateSkillFromUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromUsersRequest
      .builder()
      .skillId(SkillId.unwrap(skillId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.DisassociateSkillFromUsersRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DisassociateSkillFromUsersRequest
      .wrap(buildAwsValue())
}
object DisassociateSkillFromUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.DisassociateSkillFromUsersRequest =
      zio.aws.alexaforbusiness.model.DisassociateSkillFromUsersRequest(skillId)
    def skillId: SkillId
    def getSkillId: ZIO[Any, Nothing, SkillId] = ZIO.succeed(skillId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromUsersRequest
  ) extends zio.aws.alexaforbusiness.model.DisassociateSkillFromUsersRequest.ReadOnly {
    override val skillId: SkillId =
      zio.aws.alexaforbusiness.model.primitives.SkillId(impl.skillId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DisassociateSkillFromUsersRequest
  ): zio.aws.alexaforbusiness.model.DisassociateSkillFromUsersRequest.ReadOnly =
    new Wrapper(impl)
}
