package zio.aws.alexaforbusiness.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.alexaforbusiness.model.primitives.{
  MacAddress,
  DeviceName,
  DeviceType,
  DeviceDataCreatedTime,
  SoftwareVersion,
  Arn,
  DeviceSerialNumber,
  DeviceRoomName,
  NetworkProfileName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DeviceData(
    deviceArn: Optional[Arn] = Optional.Absent,
    deviceSerialNumber: Optional[DeviceSerialNumber] = Optional.Absent,
    deviceType: Optional[DeviceType] = Optional.Absent,
    deviceName: Optional[DeviceName] = Optional.Absent,
    softwareVersion: Optional[SoftwareVersion] = Optional.Absent,
    macAddress: Optional[MacAddress] = Optional.Absent,
    deviceStatus: Optional[zio.aws.alexaforbusiness.model.DeviceStatus] =
      Optional.Absent,
    networkProfileArn: Optional[Arn] = Optional.Absent,
    networkProfileName: Optional[NetworkProfileName] = Optional.Absent,
    roomArn: Optional[Arn] = Optional.Absent,
    roomName: Optional[DeviceRoomName] = Optional.Absent,
    deviceStatusInfo: Optional[
      zio.aws.alexaforbusiness.model.DeviceStatusInfo
    ] = Optional.Absent,
    createdTime: Optional[DeviceDataCreatedTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeviceData = {
    import DeviceData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeviceData
      .builder()
      .optionallyWith(
        deviceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.deviceArn)
      .optionallyWith(
        deviceSerialNumber.map(value =>
          DeviceSerialNumber.unwrap(value): java.lang.String
        )
      )(_.deviceSerialNumber)
      .optionallyWith(
        deviceType.map(value => DeviceType.unwrap(value): java.lang.String)
      )(_.deviceType)
      .optionallyWith(
        deviceName.map(value => DeviceName.unwrap(value): java.lang.String)
      )(_.deviceName)
      .optionallyWith(
        softwareVersion.map(value =>
          SoftwareVersion.unwrap(value): java.lang.String
        )
      )(_.softwareVersion)
      .optionallyWith(
        macAddress.map(value => MacAddress.unwrap(value): java.lang.String)
      )(_.macAddress)
      .optionallyWith(deviceStatus.map(value => value.unwrap))(_.deviceStatus)
      .optionallyWith(
        networkProfileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.networkProfileArn)
      .optionallyWith(
        networkProfileName.map(value =>
          NetworkProfileName.unwrap(value): java.lang.String
        )
      )(_.networkProfileName)
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .optionallyWith(
        roomName.map(value => DeviceRoomName.unwrap(value): java.lang.String)
      )(_.roomName)
      .optionallyWith(deviceStatusInfo.map(value => value.buildAwsValue()))(
        _.deviceStatusInfo
      )
      .optionallyWith(
        createdTime.map(value => DeviceDataCreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.DeviceData.ReadOnly =
    zio.aws.alexaforbusiness.model.DeviceData.wrap(buildAwsValue())
}
object DeviceData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeviceData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeviceData =
      zio.aws.alexaforbusiness.model.DeviceData(
        deviceArn.map(value => value),
        deviceSerialNumber.map(value => value),
        deviceType.map(value => value),
        deviceName.map(value => value),
        softwareVersion.map(value => value),
        macAddress.map(value => value),
        deviceStatus.map(value => value),
        networkProfileArn.map(value => value),
        networkProfileName.map(value => value),
        roomArn.map(value => value),
        roomName.map(value => value),
        deviceStatusInfo.map(value => value.asEditable),
        createdTime.map(value => value)
      )
    def deviceArn: Optional[Arn]
    def deviceSerialNumber: Optional[DeviceSerialNumber]
    def deviceType: Optional[DeviceType]
    def deviceName: Optional[DeviceName]
    def softwareVersion: Optional[SoftwareVersion]
    def macAddress: Optional[MacAddress]
    def deviceStatus: Optional[zio.aws.alexaforbusiness.model.DeviceStatus]
    def networkProfileArn: Optional[Arn]
    def networkProfileName: Optional[NetworkProfileName]
    def roomArn: Optional[Arn]
    def roomName: Optional[DeviceRoomName]
    def deviceStatusInfo
        : Optional[zio.aws.alexaforbusiness.model.DeviceStatusInfo.ReadOnly]
    def createdTime: Optional[DeviceDataCreatedTime]
    def getDeviceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
    def getDeviceSerialNumber: ZIO[Any, AwsError, DeviceSerialNumber] =
      AwsError.unwrapOptionField("deviceSerialNumber", deviceSerialNumber)
    def getDeviceType: ZIO[Any, AwsError, DeviceType] =
      AwsError.unwrapOptionField("deviceType", deviceType)
    def getDeviceName: ZIO[Any, AwsError, DeviceName] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getSoftwareVersion: ZIO[Any, AwsError, SoftwareVersion] =
      AwsError.unwrapOptionField("softwareVersion", softwareVersion)
    def getMacAddress: ZIO[Any, AwsError, MacAddress] =
      AwsError.unwrapOptionField("macAddress", macAddress)
    def getDeviceStatus
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.DeviceStatus] =
      AwsError.unwrapOptionField("deviceStatus", deviceStatus)
    def getNetworkProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("networkProfileArn", networkProfileArn)
    def getNetworkProfileName: ZIO[Any, AwsError, NetworkProfileName] =
      AwsError.unwrapOptionField("networkProfileName", networkProfileName)
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
    def getRoomName: ZIO[Any, AwsError, DeviceRoomName] =
      AwsError.unwrapOptionField("roomName", roomName)
    def getDeviceStatusInfo: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.DeviceStatusInfo.ReadOnly
    ] = AwsError.unwrapOptionField("deviceStatusInfo", deviceStatusInfo)
    def getCreatedTime: ZIO[Any, AwsError, DeviceDataCreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeviceData
  ) extends zio.aws.alexaforbusiness.model.DeviceData.ReadOnly {
    override val deviceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val deviceSerialNumber: Optional[DeviceSerialNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceSerialNumber())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.DeviceSerialNumber(value)
        )
    override val deviceType: Optional[DeviceType] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceType())
      .map(value => zio.aws.alexaforbusiness.model.primitives.DeviceType(value))
    override val deviceName: Optional[DeviceName] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => zio.aws.alexaforbusiness.model.primitives.DeviceName(value))
    override val softwareVersion: Optional[SoftwareVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.softwareVersion())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.SoftwareVersion(value)
        )
    override val macAddress: Optional[MacAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.macAddress())
      .map(value => zio.aws.alexaforbusiness.model.primitives.MacAddress(value))
    override val deviceStatus
        : Optional[zio.aws.alexaforbusiness.model.DeviceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceStatus())
        .map(value => zio.aws.alexaforbusiness.model.DeviceStatus.wrap(value))
    override val networkProfileArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.networkProfileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val networkProfileName: Optional[NetworkProfileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkProfileName())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.NetworkProfileName(value)
        )
    override val roomArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val roomName: Optional[DeviceRoomName] = zio.aws.core.internal
      .optionalFromNullable(impl.roomName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.DeviceRoomName(value)
      )
    override val deviceStatusInfo
        : Optional[zio.aws.alexaforbusiness.model.DeviceStatusInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceStatusInfo())
        .map(value =>
          zio.aws.alexaforbusiness.model.DeviceStatusInfo.wrap(value)
        )
    override val createdTime: Optional[DeviceDataCreatedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTime())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives.DeviceDataCreatedTime(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeviceData
  ): zio.aws.alexaforbusiness.model.DeviceData.ReadOnly = new Wrapper(impl)
}
