package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteNetworkProfileRequest(networkProfileArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.DeleteNetworkProfileRequest = {
    import DeleteNetworkProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteNetworkProfileRequest
      .builder()
      .networkProfileArn(Arn.unwrap(networkProfileArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.DeleteNetworkProfileRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.DeleteNetworkProfileRequest
      .wrap(buildAwsValue())
}
object DeleteNetworkProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.DeleteNetworkProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.DeleteNetworkProfileRequest =
      zio.aws.alexaforbusiness.model
        .DeleteNetworkProfileRequest(networkProfileArn)
    def networkProfileArn: Arn
    def getNetworkProfileArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(networkProfileArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteNetworkProfileRequest
  ) extends zio.aws.alexaforbusiness.model.DeleteNetworkProfileRequest.ReadOnly {
    override val networkProfileArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.networkProfileArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.DeleteNetworkProfileRequest
  ): zio.aws.alexaforbusiness.model.DeleteNetworkProfileRequest.ReadOnly =
    new Wrapper(impl)
}
