package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateConferenceProviderResponse(
    conferenceProviderArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderResponse = {
    import CreateConferenceProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderResponse
      .builder()
      .optionallyWith(
        conferenceProviderArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.conferenceProviderArn)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateConferenceProviderResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateConferenceProviderResponse
      .wrap(buildAwsValue())
}
object CreateConferenceProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.CreateConferenceProviderResponse =
      zio.aws.alexaforbusiness.model.CreateConferenceProviderResponse(
        conferenceProviderArn.map(value => value)
      )
    def conferenceProviderArn: Optional[Arn]
    def getConferenceProviderArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("conferenceProviderArn", conferenceProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderResponse
  ) extends zio.aws.alexaforbusiness.model.CreateConferenceProviderResponse.ReadOnly {
    override val conferenceProviderArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.conferenceProviderArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateConferenceProviderResponse
  ): zio.aws.alexaforbusiness.model.CreateConferenceProviderResponse.ReadOnly =
    new Wrapper(impl)
}
