package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  ProductDescription,
  ReviewValue,
  ReviewKey,
  GenericKeyword,
  EndUserLicenseAgreement,
  SkillStoreType,
  BulletPoint,
  ReleaseDate,
  InvocationPhrase
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SkillDetails(
    productDescription: Option[ProductDescription] = None,
    invocationPhrase: Option[InvocationPhrase] = None,
    releaseDate: Option[ReleaseDate] = None,
    endUserLicenseAgreement: Option[EndUserLicenseAgreement] = None,
    genericKeywords: Option[Iterable[GenericKeyword]] = None,
    bulletPoints: Option[Iterable[BulletPoint]] = None,
    newInThisVersionBulletPoints: Option[Iterable[BulletPoint]] = None,
    skillTypes: Option[Iterable[SkillStoreType]] = None,
    reviews: Option[Map[ReviewKey, ReviewValue]] = None,
    developerInfo: Option[zio.aws.alexaforbusiness.model.DeveloperInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SkillDetails = {
    import SkillDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SkillDetails
      .builder()
      .optionallyWith(
        productDescription.map(value =>
          ProductDescription.unwrap(value): java.lang.String
        )
      )(_.productDescription)
      .optionallyWith(
        invocationPhrase.map(value =>
          InvocationPhrase.unwrap(value): java.lang.String
        )
      )(_.invocationPhrase)
      .optionallyWith(
        releaseDate.map(value => ReleaseDate.unwrap(value): java.lang.String)
      )(_.releaseDate)
      .optionallyWith(
        endUserLicenseAgreement.map(value =>
          EndUserLicenseAgreement.unwrap(value): java.lang.String
        )
      )(_.endUserLicenseAgreement)
      .optionallyWith(
        genericKeywords.map(value =>
          value.map { item =>
            GenericKeyword.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.genericKeywords)
      .optionallyWith(
        bulletPoints.map(value =>
          value.map { item =>
            BulletPoint.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.bulletPoints)
      .optionallyWith(
        newInThisVersionBulletPoints.map(value =>
          value.map { item =>
            BulletPoint.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.newInThisVersionBulletPoints)
      .optionallyWith(
        skillTypes.map(value =>
          value.map { item =>
            SkillStoreType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.skillTypes)
      .optionallyWith(
        reviews.map(value =>
          value
            .map({ case (key, value) =>
              (ReviewKey.unwrap(key): java.lang.String) -> (ReviewValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.reviews)
      .optionallyWith(developerInfo.map(value => value.buildAwsValue()))(
        _.developerInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.SkillDetails.ReadOnly =
    zio.aws.alexaforbusiness.model.SkillDetails.wrap(buildAwsValue())
}
object SkillDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SkillDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SkillDetails =
      zio.aws.alexaforbusiness.model.SkillDetails(
        productDescription.map(value => value),
        invocationPhrase.map(value => value),
        releaseDate.map(value => value),
        endUserLicenseAgreement.map(value => value),
        genericKeywords.map(value => value),
        bulletPoints.map(value => value),
        newInThisVersionBulletPoints.map(value => value),
        skillTypes.map(value => value),
        reviews.map(value => value),
        developerInfo.map(value => value.asEditable)
      )
    def productDescription: Option[ProductDescription]
    def invocationPhrase: Option[InvocationPhrase]
    def releaseDate: Option[ReleaseDate]
    def endUserLicenseAgreement: Option[EndUserLicenseAgreement]
    def genericKeywords: Option[List[GenericKeyword]]
    def bulletPoints: Option[List[BulletPoint]]
    def newInThisVersionBulletPoints: Option[List[BulletPoint]]
    def skillTypes: Option[List[SkillStoreType]]
    def reviews: Option[Map[ReviewKey, ReviewValue]]
    def developerInfo
        : Option[zio.aws.alexaforbusiness.model.DeveloperInfo.ReadOnly]
    def getProductDescription: ZIO[Any, AwsError, ProductDescription] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getInvocationPhrase: ZIO[Any, AwsError, InvocationPhrase] =
      AwsError.unwrapOptionField("invocationPhrase", invocationPhrase)
    def getReleaseDate: ZIO[Any, AwsError, ReleaseDate] =
      AwsError.unwrapOptionField("releaseDate", releaseDate)
    def getEndUserLicenseAgreement
        : ZIO[Any, AwsError, EndUserLicenseAgreement] = AwsError
      .unwrapOptionField("endUserLicenseAgreement", endUserLicenseAgreement)
    def getGenericKeywords: ZIO[Any, AwsError, List[GenericKeyword]] =
      AwsError.unwrapOptionField("genericKeywords", genericKeywords)
    def getBulletPoints: ZIO[Any, AwsError, List[BulletPoint]] =
      AwsError.unwrapOptionField("bulletPoints", bulletPoints)
    def getNewInThisVersionBulletPoints: ZIO[Any, AwsError, List[BulletPoint]] =
      AwsError.unwrapOptionField(
        "newInThisVersionBulletPoints",
        newInThisVersionBulletPoints
      )
    def getSkillTypes: ZIO[Any, AwsError, List[SkillStoreType]] =
      AwsError.unwrapOptionField("skillTypes", skillTypes)
    def getReviews: ZIO[Any, AwsError, Map[ReviewKey, ReviewValue]] =
      AwsError.unwrapOptionField("reviews", reviews)
    def getDeveloperInfo: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.DeveloperInfo.ReadOnly
    ] = AwsError.unwrapOptionField("developerInfo", developerInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SkillDetails
  ) extends zio.aws.alexaforbusiness.model.SkillDetails.ReadOnly {
    override val productDescription: Option[ProductDescription] = scala
      .Option(impl.productDescription())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ProductDescription(value)
      )
    override val invocationPhrase: Option[InvocationPhrase] = scala
      .Option(impl.invocationPhrase())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.InvocationPhrase(value)
      )
    override val releaseDate: Option[ReleaseDate] = scala
      .Option(impl.releaseDate())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ReleaseDate(value)
      )
    override val endUserLicenseAgreement: Option[EndUserLicenseAgreement] =
      scala
        .Option(impl.endUserLicenseAgreement())
        .map(value =>
          zio.aws.alexaforbusiness.model.primitives
            .EndUserLicenseAgreement(value)
        )
    override val genericKeywords: Option[List[GenericKeyword]] = scala
      .Option(impl.genericKeywords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.primitives.GenericKeyword(item)
        }.toList
      )
    override val bulletPoints: Option[List[BulletPoint]] = scala
      .Option(impl.bulletPoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.primitives.BulletPoint(item)
        }.toList
      )
    override val newInThisVersionBulletPoints: Option[List[BulletPoint]] = scala
      .Option(impl.newInThisVersionBulletPoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.primitives.BulletPoint(item)
        }.toList
      )
    override val skillTypes: Option[List[SkillStoreType]] = scala
      .Option(impl.skillTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.primitives.SkillStoreType(item)
        }.toList
      )
    override val reviews: Option[Map[ReviewKey, ReviewValue]] = scala
      .Option(impl.reviews())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.alexaforbusiness.model.primitives.ReviewKey(
              key
            ) -> zio.aws.alexaforbusiness.model.primitives.ReviewValue(value)
          })
          .toMap
      )
    override val developerInfo
        : Option[zio.aws.alexaforbusiness.model.DeveloperInfo.ReadOnly] = scala
      .Option(impl.developerInfo())
      .map(value => zio.aws.alexaforbusiness.model.DeveloperInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SkillDetails
  ): zio.aws.alexaforbusiness.model.SkillDetails.ReadOnly = new Wrapper(impl)
}
