package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  RoomSkillParameterValue,
  RoomSkillParameterKey
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RoomSkillParameter(
    parameterKey: RoomSkillParameterKey,
    parameterValue: RoomSkillParameterValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.RoomSkillParameter = {
    import RoomSkillParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.RoomSkillParameter
      .builder()
      .parameterKey(
        RoomSkillParameterKey.unwrap(parameterKey): java.lang.String
      )
      .parameterValue(
        RoomSkillParameterValue.unwrap(parameterValue): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.RoomSkillParameter.ReadOnly =
    zio.aws.alexaforbusiness.model.RoomSkillParameter.wrap(buildAwsValue())
}
object RoomSkillParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.RoomSkillParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.RoomSkillParameter =
      zio.aws.alexaforbusiness.model
        .RoomSkillParameter(parameterKey, parameterValue)
    def parameterKey: RoomSkillParameterKey
    def parameterValue: RoomSkillParameterValue
    def getParameterKey: ZIO[Any, Nothing, RoomSkillParameterKey] =
      ZIO.succeed(parameterKey)
    def getParameterValue: ZIO[Any, Nothing, RoomSkillParameterValue] =
      ZIO.succeed(parameterValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RoomSkillParameter
  ) extends zio.aws.alexaforbusiness.model.RoomSkillParameter.ReadOnly {
    override val parameterKey: RoomSkillParameterKey =
      zio.aws.alexaforbusiness.model.primitives
        .RoomSkillParameterKey(impl.parameterKey())
    override val parameterValue: RoomSkillParameterValue =
      zio.aws.alexaforbusiness.model.primitives
        .RoomSkillParameterValue(impl.parameterValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.RoomSkillParameter
  ): zio.aws.alexaforbusiness.model.RoomSkillParameter.ReadOnly = new Wrapper(
    impl
  )
}
