package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{SkillId, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutRoomSkillParameterRequest(
    roomArn: Option[Arn] = None,
    skillId: SkillId,
    roomSkillParameter: zio.aws.alexaforbusiness.model.RoomSkillParameter
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterRequest = {
    import PutRoomSkillParameterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterRequest
      .builder()
      .optionallyWith(
        roomArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roomArn)
      .skillId(SkillId.unwrap(skillId): java.lang.String)
      .roomSkillParameter(roomSkillParameter.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.PutRoomSkillParameterRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.PutRoomSkillParameterRequest
      .wrap(buildAwsValue())
}
object PutRoomSkillParameterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.PutRoomSkillParameterRequest =
      zio.aws.alexaforbusiness.model.PutRoomSkillParameterRequest(
        roomArn.map(value => value),
        skillId,
        roomSkillParameter.asEditable
      )
    def roomArn: Option[Arn]
    def skillId: SkillId
    def roomSkillParameter
        : zio.aws.alexaforbusiness.model.RoomSkillParameter.ReadOnly
    def getRoomArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roomArn", roomArn)
    def getSkillId: ZIO[Any, Nothing, SkillId] = ZIO.succeed(skillId)
    def getRoomSkillParameter: ZIO[
      Any,
      Nothing,
      zio.aws.alexaforbusiness.model.RoomSkillParameter.ReadOnly
    ] = ZIO.succeed(roomSkillParameter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterRequest
  ) extends zio.aws.alexaforbusiness.model.PutRoomSkillParameterRequest.ReadOnly {
    override val roomArn: Option[Arn] = scala
      .Option(impl.roomArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val skillId: SkillId =
      zio.aws.alexaforbusiness.model.primitives.SkillId(impl.skillId())
    override val roomSkillParameter
        : zio.aws.alexaforbusiness.model.RoomSkillParameter.ReadOnly =
      zio.aws.alexaforbusiness.model.RoomSkillParameter
        .wrap(impl.roomSkillParameter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.PutRoomSkillParameterRequest
  ): zio.aws.alexaforbusiness.model.PutRoomSkillParameterRequest.ReadOnly =
    new Wrapper(impl)
}
