package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{MaxResults, NextToken, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDeviceEventsRequest(
    deviceArn: Arn,
    eventType: Option[zio.aws.alexaforbusiness.model.DeviceEventType] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest = {
    import ListDeviceEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest
      .builder()
      .deviceArn(Arn.unwrap(deviceArn): java.lang.String)
      .optionallyWith(eventType.map(value => value.unwrap))(_.eventType)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.ListDeviceEventsRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.ListDeviceEventsRequest.wrap(buildAwsValue())
}
object ListDeviceEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.ListDeviceEventsRequest =
      zio.aws.alexaforbusiness.model.ListDeviceEventsRequest(
        deviceArn,
        eventType.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def deviceArn: Arn
    def eventType: Option[zio.aws.alexaforbusiness.model.DeviceEventType]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getDeviceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(deviceArn)
    def getEventType
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.DeviceEventType] =
      AwsError.unwrapOptionField("eventType", eventType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest
  ) extends zio.aws.alexaforbusiness.model.ListDeviceEventsRequest.ReadOnly {
    override val deviceArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.deviceArn())
    override val eventType
        : Option[zio.aws.alexaforbusiness.model.DeviceEventType] = scala
      .Option(impl.eventType())
      .map(value => zio.aws.alexaforbusiness.model.DeviceEventType.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.alexaforbusiness.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.alexaforbusiness.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.ListDeviceEventsRequest
  ): zio.aws.alexaforbusiness.model.ListDeviceEventsRequest.ReadOnly =
    new Wrapper(impl)
}
