package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetGatewayResponse(
    gateway: Option[zio.aws.alexaforbusiness.model.Gateway] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayResponse = {
    import GetGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayResponse
      .builder()
      .optionallyWith(gateway.map(value => value.buildAwsValue()))(_.gateway)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.GetGatewayResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.GetGatewayResponse.wrap(buildAwsValue())
}
object GetGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetGatewayResponse =
      zio.aws.alexaforbusiness.model
        .GetGatewayResponse(gateway.map(value => value.asEditable))
    def gateway: Option[zio.aws.alexaforbusiness.model.Gateway.ReadOnly]
    def getGateway
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.Gateway.ReadOnly] =
      AwsError.unwrapOptionField("gateway", gateway)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayResponse
  ) extends zio.aws.alexaforbusiness.model.GetGatewayResponse.ReadOnly {
    override val gateway
        : Option[zio.aws.alexaforbusiness.model.Gateway.ReadOnly] = scala
      .Option(impl.gateway())
      .map(value => zio.aws.alexaforbusiness.model.Gateway.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetGatewayResponse
  ): zio.aws.alexaforbusiness.model.GetGatewayResponse.ReadOnly = new Wrapper(
    impl
  )
}
