package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDeviceResponse(
    device: Option[zio.aws.alexaforbusiness.model.Device] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceResponse = {
    import GetDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceResponse
      .builder()
      .optionallyWith(device.map(value => value.buildAwsValue()))(_.device)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.GetDeviceResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.GetDeviceResponse.wrap(buildAwsValue())
}
object GetDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetDeviceResponse =
      zio.aws.alexaforbusiness.model
        .GetDeviceResponse(device.map(value => value.asEditable))
    def device: Option[zio.aws.alexaforbusiness.model.Device.ReadOnly]
    def getDevice
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.Device.ReadOnly] =
      AwsError.unwrapOptionField("device", device)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceResponse
  ) extends zio.aws.alexaforbusiness.model.GetDeviceResponse.ReadOnly {
    override val device
        : Option[zio.aws.alexaforbusiness.model.Device.ReadOnly] = scala
      .Option(impl.device())
      .map(value => zio.aws.alexaforbusiness.model.Device.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetDeviceResponse
  ): zio.aws.alexaforbusiness.model.GetDeviceResponse.ReadOnly = new Wrapper(
    impl
  )
}
