package zio.aws.alexaforbusiness.model
import scala.jdk.CollectionConverters.*
sealed trait DeviceUsageType {
  def unwrap
      : software.amazon.awssdk.services.alexaforbusiness.model.DeviceUsageType
}
object DeviceUsageType {
  def wrap(
      value: software.amazon.awssdk.services.alexaforbusiness.model.DeviceUsageType
  ): zio.aws.alexaforbusiness.model.DeviceUsageType = value match {
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceUsageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.alexaforbusiness.model.DeviceUsageType.VOICE =>
      val r = VOICE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.alexaforbusiness.model.DeviceUsageType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceUsageType =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceUsageType.UNKNOWN_TO_SDK_VERSION
  }
  case object VOICE extends zio.aws.alexaforbusiness.model.DeviceUsageType {
    override def unwrap
        : software.amazon.awssdk.services.alexaforbusiness.model.DeviceUsageType =
      software.amazon.awssdk.services.alexaforbusiness.model.DeviceUsageType.VOICE
  }
}
