package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  ClientRequestToken,
  Arn,
  ProviderCalendarId,
  RoomName,
  RoomDescription
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateRoomRequest(
    roomName: RoomName,
    description: Option[RoomDescription] = None,
    profileArn: Option[Arn] = None,
    providerCalendarId: Option[ProviderCalendarId] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    tags: Option[Iterable[zio.aws.alexaforbusiness.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomRequest = {
    import CreateRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomRequest
      .builder()
      .roomName(RoomName.unwrap(roomName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          RoomDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        profileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.profileArn)
      .optionallyWith(
        providerCalendarId.map(value =>
          ProviderCalendarId.unwrap(value): java.lang.String
        )
      )(_.providerCalendarId)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.CreateRoomRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateRoomRequest.wrap(buildAwsValue())
}
object CreateRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateRoomRequest =
      zio.aws.alexaforbusiness.model.CreateRoomRequest(
        roomName,
        description.map(value => value),
        profileArn.map(value => value),
        providerCalendarId.map(value => value),
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def roomName: RoomName
    def description: Option[RoomDescription]
    def profileArn: Option[Arn]
    def providerCalendarId: Option[ProviderCalendarId]
    def clientRequestToken: Option[ClientRequestToken]
    def tags: Option[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]]
    def getRoomName: ZIO[Any, Nothing, RoomName] = ZIO.succeed(roomName)
    def getDescription: ZIO[Any, AwsError, RoomDescription] =
      AwsError.unwrapOptionField("description", description)
    def getProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("profileArn", profileArn)
    def getProviderCalendarId: ZIO[Any, AwsError, ProviderCalendarId] =
      AwsError.unwrapOptionField("providerCalendarId", providerCalendarId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomRequest
  ) extends zio.aws.alexaforbusiness.model.CreateRoomRequest.ReadOnly {
    override val roomName: RoomName =
      zio.aws.alexaforbusiness.model.primitives.RoomName(impl.roomName())
    override val description: Option[RoomDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.RoomDescription(value)
      )
    override val profileArn: Option[Arn] = scala
      .Option(impl.profileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
    override val providerCalendarId: Option[ProviderCalendarId] = scala
      .Option(impl.providerCalendarId())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ProviderCalendarId(value)
      )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ClientRequestToken(value)
      )
    override val tags
        : Option[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateRoomRequest
  ): zio.aws.alexaforbusiness.model.CreateRoomRequest.ReadOnly = new Wrapper(
    impl
  )
}
