package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateConferenceProviderRequest(
    conferenceProviderArn: Arn,
    conferenceProviderType: zio.aws.alexaforbusiness.model.ConferenceProviderType,
    ipDialIn: Option[zio.aws.alexaforbusiness.model.IPDialIn] = None,
    pstnDialIn: Option[zio.aws.alexaforbusiness.model.PSTNDialIn] = None,
    meetingSetting: zio.aws.alexaforbusiness.model.MeetingSetting
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.UpdateConferenceProviderRequest = {
    import UpdateConferenceProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateConferenceProviderRequest
      .builder()
      .conferenceProviderArn(
        Arn.unwrap(conferenceProviderArn): java.lang.String
      )
      .conferenceProviderType(conferenceProviderType.unwrap)
      .optionallyWith(ipDialIn.map(value => value.buildAwsValue()))(_.ipDialIn)
      .optionallyWith(pstnDialIn.map(value => value.buildAwsValue()))(
        _.pstnDialIn
      )
      .meetingSetting(meetingSetting.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.UpdateConferenceProviderRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.UpdateConferenceProviderRequest
      .wrap(buildAwsValue())
}
object UpdateConferenceProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.UpdateConferenceProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.UpdateConferenceProviderRequest =
      zio.aws.alexaforbusiness.model.UpdateConferenceProviderRequest(
        conferenceProviderArn,
        conferenceProviderType,
        ipDialIn.map(value => value.asEditable),
        pstnDialIn.map(value => value.asEditable),
        meetingSetting.asEditable
      )
    def conferenceProviderArn: Arn
    def conferenceProviderType
        : zio.aws.alexaforbusiness.model.ConferenceProviderType
    def ipDialIn: Option[zio.aws.alexaforbusiness.model.IPDialIn.ReadOnly]
    def pstnDialIn: Option[zio.aws.alexaforbusiness.model.PSTNDialIn.ReadOnly]
    def meetingSetting: zio.aws.alexaforbusiness.model.MeetingSetting.ReadOnly
    def getConferenceProviderArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(conferenceProviderArn)
    def getConferenceProviderType: ZIO[
      Any,
      Nothing,
      zio.aws.alexaforbusiness.model.ConferenceProviderType
    ] = ZIO.succeed(conferenceProviderType)
    def getIpDialIn
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.IPDialIn.ReadOnly] =
      AwsError.unwrapOptionField("ipDialIn", ipDialIn)
    def getPstnDialIn: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.PSTNDialIn.ReadOnly
    ] = AwsError.unwrapOptionField("pstnDialIn", pstnDialIn)
    def getMeetingSetting: ZIO[
      Any,
      Nothing,
      zio.aws.alexaforbusiness.model.MeetingSetting.ReadOnly
    ] = ZIO.succeed(meetingSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateConferenceProviderRequest
  ) extends zio.aws.alexaforbusiness.model.UpdateConferenceProviderRequest.ReadOnly {
    override val conferenceProviderArn: Arn =
      zio.aws.alexaforbusiness.model.primitives
        .Arn(impl.conferenceProviderArn())
    override val conferenceProviderType
        : zio.aws.alexaforbusiness.model.ConferenceProviderType =
      zio.aws.alexaforbusiness.model.ConferenceProviderType
        .wrap(impl.conferenceProviderType())
    override val ipDialIn
        : Option[zio.aws.alexaforbusiness.model.IPDialIn.ReadOnly] = scala
      .Option(impl.ipDialIn())
      .map(value => zio.aws.alexaforbusiness.model.IPDialIn.wrap(value))
    override val pstnDialIn
        : Option[zio.aws.alexaforbusiness.model.PSTNDialIn.ReadOnly] = scala
      .Option(impl.pstnDialIn())
      .map(value => zio.aws.alexaforbusiness.model.PSTNDialIn.wrap(value))
    override val meetingSetting
        : zio.aws.alexaforbusiness.model.MeetingSetting.ReadOnly =
      zio.aws.alexaforbusiness.model.MeetingSetting.wrap(impl.meetingSetting())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.UpdateConferenceProviderRequest
  ): zio.aws.alexaforbusiness.model.UpdateConferenceProviderRequest.ReadOnly =
    new Wrapper(impl)
}
