package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartSmartHomeApplianceDiscoveryRequest(roomArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryRequest = {
    import StartSmartHomeApplianceDiscoveryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryRequest
      .builder()
      .roomArn(Arn.unwrap(roomArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryRequest
      .wrap(buildAwsValue())
}
object StartSmartHomeApplianceDiscoveryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryRequest =
      zio.aws.alexaforbusiness.model
        .StartSmartHomeApplianceDiscoveryRequest(roomArn)
    def roomArn: Arn
    def getRoomArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roomArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryRequest
  ) extends zio.aws.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryRequest.ReadOnly {
    override val roomArn: Arn =
      zio.aws.alexaforbusiness.model.primitives.Arn(impl.roomArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryRequest
  ): zio.aws.alexaforbusiness.model.StartSmartHomeApplianceDiscoveryRequest.ReadOnly =
    new Wrapper(impl)
}
