package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.SsmlValue
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Ssml(
    locale: zio.aws.alexaforbusiness.model.Locale,
    value: SsmlValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.Ssml = {
    import Ssml.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.Ssml
      .builder()
      .locale(locale.unwrap)
      .value(SsmlValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.Ssml.ReadOnly =
    zio.aws.alexaforbusiness.model.Ssml.wrap(buildAwsValue())
}
object Ssml {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.Ssml
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.Ssml =
      zio.aws.alexaforbusiness.model.Ssml(locale, value)
    def locale: zio.aws.alexaforbusiness.model.Locale
    def value: SsmlValue
    def getLocale: ZIO[Any, Nothing, zio.aws.alexaforbusiness.model.Locale] =
      ZIO.succeed(locale)
    def getValue: ZIO[Any, Nothing, SsmlValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Ssml
  ) extends zio.aws.alexaforbusiness.model.Ssml.ReadOnly {
    override val locale: zio.aws.alexaforbusiness.model.Locale =
      zio.aws.alexaforbusiness.model.Locale.wrap(impl.locale())
    override val value: SsmlValue =
      zio.aws.alexaforbusiness.model.primitives.SsmlValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.Ssml
  ): zio.aws.alexaforbusiness.model.Ssml.ReadOnly = new Wrapper(impl)
}
