package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{SkillName, SkillId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SkillSummary(
    skillId: Option[SkillId] = None,
    skillName: Option[SkillName] = None,
    supportsLinking: Option[Boolean] = None,
    enablementType: Option[zio.aws.alexaforbusiness.model.EnablementType] =
      None,
    skillType: Option[zio.aws.alexaforbusiness.model.SkillType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.SkillSummary = {
    import SkillSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.SkillSummary
      .builder()
      .optionallyWith(
        skillId.map(value => SkillId.unwrap(value): java.lang.String)
      )(_.skillId)
      .optionallyWith(
        skillName.map(value => SkillName.unwrap(value): java.lang.String)
      )(_.skillName)
      .optionallyWith(supportsLinking.map(value => value: java.lang.Boolean))(
        _.supportsLinking
      )
      .optionallyWith(enablementType.map(value => value.unwrap))(
        _.enablementType
      )
      .optionallyWith(skillType.map(value => value.unwrap))(_.skillType)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.SkillSummary.ReadOnly =
    zio.aws.alexaforbusiness.model.SkillSummary.wrap(buildAwsValue())
}
object SkillSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.SkillSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.SkillSummary =
      zio.aws.alexaforbusiness.model.SkillSummary(
        skillId.map(value => value),
        skillName.map(value => value),
        supportsLinking.map(value => value),
        enablementType.map(value => value),
        skillType.map(value => value)
      )
    def skillId: Option[SkillId]
    def skillName: Option[SkillName]
    def supportsLinking: Option[Boolean]
    def enablementType: Option[zio.aws.alexaforbusiness.model.EnablementType]
    def skillType: Option[zio.aws.alexaforbusiness.model.SkillType]
    def getSkillId: ZIO[Any, AwsError, SkillId] =
      AwsError.unwrapOptionField("skillId", skillId)
    def getSkillName: ZIO[Any, AwsError, SkillName] =
      AwsError.unwrapOptionField("skillName", skillName)
    def getSupportsLinking: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("supportsLinking", supportsLinking)
    def getEnablementType
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.EnablementType] =
      AwsError.unwrapOptionField("enablementType", enablementType)
    def getSkillType
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.SkillType] =
      AwsError.unwrapOptionField("skillType", skillType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SkillSummary
  ) extends zio.aws.alexaforbusiness.model.SkillSummary.ReadOnly {
    override val skillId: Option[SkillId] = scala
      .Option(impl.skillId())
      .map(value => zio.aws.alexaforbusiness.model.primitives.SkillId(value))
    override val skillName: Option[SkillName] = scala
      .Option(impl.skillName())
      .map(value => zio.aws.alexaforbusiness.model.primitives.SkillName(value))
    override val supportsLinking: Option[Boolean] =
      scala.Option(impl.supportsLinking()).map(value => value: Boolean)
    override val enablementType
        : Option[zio.aws.alexaforbusiness.model.EnablementType] = scala
      .Option(impl.enablementType())
      .map(value => zio.aws.alexaforbusiness.model.EnablementType.wrap(value))
    override val skillType: Option[zio.aws.alexaforbusiness.model.SkillType] =
      scala
        .Option(impl.skillType())
        .map(value => zio.aws.alexaforbusiness.model.SkillType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.SkillSummary
  ): zio.aws.alexaforbusiness.model.SkillSummary.ReadOnly = new Wrapper(impl)
}
